const express = require('express');
const router = express.Router();
const titleChecker = require('../services/titleChecker');

// Get all history
router.get('/', async (req, res) => {
    try {
        const { limit = 100, websiteId } = req.query;
        let history = await titleChecker.loadHistory();

        // Filter by websiteId if provided
        if (websiteId) {
            history = history.filter(h => h.websiteId === websiteId);
        }

        // Limit results
        history = history.slice(0, parseInt(limit));

        res.json({ success: true, history });
    } catch (error) {
        res.status(500).json({ success: false, error: error.message });
    }
});

// Get history for specific website
router.get('/:websiteId', async (req, res) => {
    try {
        const { websiteId } = req.params;
        const { limit = 50 } = req.query;

        const history = await titleChecker.loadHistory();
        const filtered = history
            .filter(h => h.websiteId === websiteId)
            .slice(0, parseInt(limit));

        res.json({ success: true, history: filtered });
    } catch (error) {
        res.status(500).json({ success: false, error: error.message });
    }
});

// Clear old history (keep last 100)
router.delete('/', async (req, res) => {
    try {
        const history = await titleChecker.loadHistory();
        const trimmed = history.slice(0, 100);
        await titleChecker.saveHistory(trimmed);

        res.json({
            success: true,
            message: `Kept ${trimmed.length} entries, deleted ${history.length - trimmed.length}`
        });
    } catch (error) {
        res.status(500).json({ success: false, error: error.message });
    }
});

module.exports = router;
